#version 140
#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D texture0;   // dancer feed
uniform vec2 textureSize0;    // resolution of dancer texture
varying vec4 gl_TexCoord[];

float luma(vec3 c) {
    return dot(c, vec3(0.299, 0.587, 0.114));
}

void main(void) {
    vec2 uv = gl_TexCoord[0].xy;

    // --- Edge detection ---
    vec4 rgbNW = texture2D(texture0, uv + vec2(-1.0, -1.0) / textureSize0);
    vec4 rgbNE = texture2D(texture0, uv + vec2( 1.0, -1.0) / textureSize0);
    vec4 rgbSW = texture2D(texture0, uv + vec2(-1.0,  1.0) / textureSize0);
    vec4 rgbSE = texture2D(texture0, uv + vec2( 1.0,  1.0) / textureSize0);
    vec4 rgbM  = texture2D(texture0, uv);

    float lumaNW = luma(rgbNW.rgb);
    float lumaNE = luma(rgbNE.rgb);
    float lumaSW = luma(rgbSW.rgb);
    float lumaSE = luma(rgbSE.rgb);
    float lumaM  = luma(rgbM.rgb);

    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

    float edgeStrength = clamp(lumaMax - lumaMin, 0.0, 1.0);
    float insideMask = 1.0 - smoothstep(0.05, 0.2, edgeStrength);

    // Cylindrical gradient
    float cyl = 1.0 - abs(uv.x - 0.5) * 2.0;
    cyl = clamp(cyl, 0.0, 1.0);

    float depthMask = insideMask * cyl;

    // Pixel shift for right eye
    float maxShift = 5.0 / textureSize0.x;
    vec2 offset = vec2((depthMask - 0.5) * maxShift, 0.0);

    vec4 rightEye = texture2D(texture0, uv + offset);
    rightEye.a = insideMask;

    gl_FragColor = rightEye;
}
